/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.config.ConfigurableField;
import jace.core.Computer;
import jace.core.Device;
import jace.core.Motherboard;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class Speaker
extends Device {
    private double counter = 0.0;
    private int level = 0;
    private int idleCycles = 0;
    @ConfigurableField(name="Bits per sample")
    public static int BITS = 16;
    @ConfigurableField(name="Playback Rate")
    public static int RATE = 44100;
    static int BUFFER_SIZE = (int)((double)RATE * 0.4);
    static int MIN_PLAYBACK_BUFFER = BUFFER_SIZE / 2;
    private int MIN_SAMPLE_PLAYBACK = BUFFER_SIZE / 4;
    @ConfigurableField(name="Speaker Volume", description="Should be < 1400")
    public static int VOLUME = 600;
    @ConfigurableField(name="Idle cycles before sleep")
    public static int MAX_IDLE_CYCLES = 2000000;
    private SourceDataLine sdl;
    private AudioFormat af;
    public boolean lineAvailable;
    private boolean speakerBit = false;
    private final Object bufferLock = new Object();
    byte[] soundBuffer1;
    byte[] soundBuffer2;
    int currentBuffer = 1;
    int bufferPos = 0;
    private double TICKS_PER_SAMPLE = (double)Motherboard.SPEED / (double)RATE;
    private double TICKS_PER_SAMPLE_FLOOR = Math.floor(this.TICKS_PER_SAMPLE);
    Thread playbackThread;
    private RAMListener listener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

        protected void doConfig() {
            this.setScopeStart(49200);
            this.setScopeEnd(49215);
        }

        protected void doEvent(RAMEvent e) {
            Speaker.this.speakerBit = !Speaker.this.speakerBit;
            Speaker.this.resetIdle();
        }
    };

    public Speaker() {
        try {
            this.lineAvailable = true;
            this.reconfigure();
            this.initAudio();
            this.configureListener();
        }
        catch (LineUnavailableException ex) {
            Logger.getLogger(Speaker.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("Could not initalize sound!");
        }
    }

    public void suspend() {
        try {
            this.setRun(false);
            Motherboard.cancelSpeedRequest(this);
            this.speakerBit = false;
            if (this.playbackThread != null && this.playbackThread.isAlive()) {
                this.playbackThread.join();
                this.playbackThread = null;
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Speaker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void resume() {
        if (this.lineAvailable) {
            this.setRun(true);
            this.counter = 0.0;
            this.idleCycles = 0;
            this.level = 0;
            this.bufferPos = 0;
            if (this.playbackThread == null || !this.playbackThread.isAlive()) {
                this.playbackThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int len = 0;
                        while (Speaker.this.isRunning()) {
                            len = Speaker.this.bufferPos;
                            if (len >= Speaker.this.MIN_SAMPLE_PLAYBACK) {
                                byte[] buffer;
                                Object object = Speaker.this.bufferLock;
                                synchronized (object) {
                                    buffer = Speaker.this.currentBuffer == 1 ? Speaker.this.soundBuffer1 : Speaker.this.soundBuffer2;
                                    Speaker.this.currentBuffer = Speaker.this.currentBuffer == 1 ? 2 : 1;
                                    Speaker.this.bufferPos = 0;
                                }
                                Speaker.this.sdl.start();
                                Speaker.this.sdl.write(buffer, 0, len);
                                continue;
                            }
                            LockSupport.parkNanos(5000L);
                        }
                        Speaker.this.sdl.drain();
                        Speaker.this.sdl.flush();
                    }
                });
                this.playbackThread.start();
            }
        }
    }

    public void resetIdle() {
        this.idleCycles = 0;
        if (!this.isRunning()) {
            this.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (!this.isRunning()) {
            return;
        }
        if (this.idleCycles++ >= MAX_IDLE_CYCLES) {
            this.suspend();
        }
        if (this.speakerBit) {
            ++this.level;
        }
        this.counter += 1.0;
        if (this.counter >= this.TICKS_PER_SAMPLE) {
            while (this.bufferPos >= BUFFER_SIZE) {
                LockSupport.parkNanos(1000L);
            }
            int sample = this.level * VOLUME;
            byte hi = (byte)((0xFF00 & sample) >> 8);
            byte lo = (byte)(0xFF & sample);
            Object object = this.bufferLock;
            synchronized (object) {
                if (this.currentBuffer == 1) {
                    byte by = hi;
                    this.soundBuffer1[this.bufferPos + 2] = by;
                    this.soundBuffer1[this.bufferPos] = by;
                    byte by2 = lo;
                    this.soundBuffer1[this.bufferPos + 3] = by2;
                    this.soundBuffer1[this.bufferPos + 1] = by2;
                } else {
                    byte by = hi;
                    this.soundBuffer2[this.bufferPos + 2] = by;
                    this.soundBuffer2[this.bufferPos] = by;
                    byte by3 = lo;
                    this.soundBuffer2[this.bufferPos + 3] = by3;
                    this.soundBuffer2[this.bufferPos + 1] = by3;
                }
                this.bufferPos += 4;
            }
            this.level = 0;
            this.counter -= this.TICKS_PER_SAMPLE_FLOOR;
        }
    }

    private void initAudio() throws LineUnavailableException {
        Line l;
        this.af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, RATE, BITS, 2, 4, RATE, true);
        DataLine.Info dli = new DataLine.Info(SourceDataLine.class, this.af);
        for (Mixer.Info mixer : AudioSystem.getMixerInfo()) {
            System.out.println(mixer.getName() + ":" + mixer.getDescription());
        }
        if (AudioSystem.isLineSupported(dli)) {
            l = null;
            try {
                l = AudioSystem.getLine(dli);
            }
            catch (LineUnavailableException e) {
                this.lineAvailable = false;
                throw e;
            }
            if (!(l instanceof SourceDataLine)) {
                this.lineAvailable = false;
                throw new LineUnavailableException("Line is not an output line!");
            }
        } else {
            this.lineAvailable = false;
            throw new LineUnavailableException("Line not supported!");
        }
        this.sdl = (SourceDataLine)l;
        if (this.sdl == null) {
            this.lineAvailable = false;
            throw new LineUnavailableException("line not found");
        }
        if (this.lineAvailable) {
            this.sdl.open(this.af);
        }
    }

    private void configureListener() {
        Computer.getComputer().getMemory().addListener(this.listener);
    }

    private void removeListener() {
        Computer.getComputer().getMemory().removeListener(this.listener);
    }

    protected String getDeviceName() {
        return "Speaker";
    }

    public void reconfigure() {
        BUFFER_SIZE = (int)((double)RATE * 0.4);
        MIN_PLAYBACK_BUFFER = BUFFER_SIZE / 2;
        this.MIN_SAMPLE_PLAYBACK = BUFFER_SIZE / 4;
        this.soundBuffer1 = new byte[BUFFER_SIZE];
        this.soundBuffer2 = new byte[BUFFER_SIZE];
    }

    public void attach() {
        this.configureListener();
        if (!this.lineAvailable) {
            try {
                this.initAudio();
                this.resume();
            }
            catch (LineUnavailableException ex) {
                Logger.getLogger(Speaker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void detach() {
        this.removeListener();
        this.suspend();
    }
}

